/*
========================================================================================================================
 Resource API: "adr-patient-demographics"

 [GET] "/adr/v1/patients/{patient-icn}/demographics"

    Parameters:
        patient-icn (string) The ICN of patient

========================================================================================================================
 Schema: {
    "CommunityCareEligibilityInfo": {
      "type": "object",
      "properties": {
        "vceCode": {
          "type": "string"
        },
        "vceDescription": {
          "type": "string"
        },
        "vceEffectiveDate": {
          "type": "string",
          "format":"date-time"
        }
      }
    },
 }

========================================================================================================================
 Example: {
     <communityCareEligibilityInfo>
        <vceCode>X</vceCode>
        <vceDescription>No longer eligible for the Veterans Choice Program</vceDescription>
        <vceEffectiveDate>2017-08-20T18:24:18.000-05:00</vceEffectiveDate>
     </communityCareEligibilityInfo>
 }

========================================================================================================================
 */
define([
    'underscore',
    'models/abstract-model',
    'User',
], function(_, Model, user) {
    'use strict';


    return Model.extend({
        resourceName: 'adr-patient-demographics',
        vceCode: null,

        url: function() {
            var resource = this.getResource();

            return resource.formatHref({
                'patient-icn': user.get('id'),
            });
        },

        parse: function(response) {
            var hasVce = response.communityCareEligibilityInfo && response.communityCareEligibilityInfo.vceCode;
            if (hasVce) {
                this.set('vceCode', response.communityCareEligibilityInfo.vceCode);
            }
            return response;
        },

        /*  vce Codes
            Eligible:
             M=Mileage
             H=Hardship
            Not eligible:
             B=basic
             WT=Wait-time
             MWT=Mileage and Wait-time
             HWT=Hardship and Wait-time
             X=Ineligible
        */
        /* eslint-disable vars-on-top */
        isCcEligible: function() {
            var eligibleCodes = ['M', 'H', 'MWT', 'HWT'];
            if (!_.isUndefined(this.get('vceCode')) && !_.isNull(this.get('vceCode'))) {
                var vceCode = this.get('vceCode').toUpperCase();
                return eligibleCodes.indexOf(vceCode) !== -1;
            }
            return false;
        },

    });
});
